﻿var edittimeslot = {
    context: $(".v-editTimeSlots"),
    projectId: $("#ProjectId").val(),
    shiftId: $("#Id").val(),
    initialize: function () {
        a4.initializeInputs(this.context);

        edittimeslot.createTimeSlotsCounterGrid();
    },
    createTimeSlotsCounterGrid: function () {
        var dynamicGridsContainer = $(".v-dnisDynamicGridEditorContainer");
        if (dynamicGridsContainer.length > 0) {
            $(".v-dynamicEditor", dynamicGridsContainer).each(function () {
                var editor = $(this);

                editor.on("click", ".h-deleteRow", function () {
                    var item = $(this).closest(".v-editableItem");
                    item.addClass("deleted");
                    item.hide();

                    $(".v-rowState", item).val(2); // deleted

                    edittimeslot.replaceItemIndexes(item);
                });

                editor.on("change", ".h-updateRowState", function () {
                    edittimeslot.updateItemRowState($(this));
                });

                editor.on("click", ".v-addRow", function () {
                    var rowId = $(".v-dynamicTableBody tr", editor).length + 1;
                    var rowPosition = $(".v-dynamicTableBody tr:visible", editor).length + 1;

                    $('.v-dynamicEditorTable', editor).show();

                    var newItem = $(".v-newItems .v-newItemBody tr", editor).clone();

                    if (rowId == 1) {
                        var newValue = 1;
                    }
                    else {
                        var newValue = parseInt($(".v-dynamicTableBody tr:not(.deleted):last td:nth-child(2) input", editor).val()) + 1;
                    }

                    newItem.find(".v-itemIndex").html(rowPosition);
                    newItem.find(".v-rowPosition").val(newValue);

                    newItem.removeClass("row0");
                    newItem.addClass("row" + rowId);

                    var editorControlName = $(".editorControlName", editor).attr("id");
                    $("input, select", newItem).each(function () {
                        $(this).attr("id", editorControlName + "[" + (rowId - 1) + "]" + $(this).attr("id"));
                        $(this).attr("name", editorControlName + "[" + (rowId - 1) + "]." + $(this).attr("name"));
                    });

                    newItem.appendTo($("table .v-dynamicTableBody", editor));

                    $(".row" + rowId + " input", editor).on("keypress", function (e) { return edittimeslot.disableEnter(e); });

                    a4.initializeInputs(newItem);
                });
            });
        }
    },
    updateItemRowState: function (triggerField) {
        var stateField = $(".v-rowState", triggerField.parents(".v-editableItem"));
        if (stateField.val() == 1)
            stateField.val(3); // updated
    },
    replaceItemIndexes: function (startItem, increaseStartItem) {
        // Replace order if item deleted
        var previousIndex = $(".v-itemIndex", startItem).html();

        // For cancel of delete
        if (increaseStartItem) {
            previousIndex++;
        }

        startItem.nextAll(".v-editableItem:visible").each(function () {
            $(".v-itemIndex", $(this)).html(previousIndex);
            previousIndex++;
        });
    },
    disableEnter: function (_e) {
        return (_e.keyCode != 13);
    }
};


$(document).ready(function () {
    if (edittimeslot.context.length > 0) {
        edittimeslot.initialize();
    }
});